BEGIN_SYMBOL_DEFINITIONS

    <!-- XPROJECT table -->
    COLS:XPROJECT=XPROJECT:*
 	COLS:XPROJECT_ID=XPROJECT:XPROJECT_ID
 	<!-- XPRJDES table -->
  	COLS:XPRJDES=XPRJDES:*
    <!-- XPRJMTR table -->
  	COLS:XPRJMTR=XPRJMTR:*
  	<!-- XPRJMTRDES table -->
	COLS:XPRJMTRDES=XPRJMTRDES:*
	<!-- XPRJMTRCATREL table -->
	COLS:XPRJMTRCATREL=XPRJMTRCATREL:*
    <!-- XPRJINS table -->
	COLS:XPRJINS=XPRJINS:*
	<!-- XPRJINSDES table -->
	COLS:XPRJINSDES=XPRJINSDES:*
	<!-- XPRJPRJCOLREL table -->
	COLS:XPRJPRJCOLREL=XPRJPRJCOLREL:*
	<!-- XPRJCOL table -->
	COLS:XPRJCOL=XPRJCOL:*
	<!-- XPRJCOLDES table -->
	COLS:XPRJCOLDES=XPRJCOLDES:*
	<!-- XPRJCATREL table -->
	COLS:XPRJCATREL=XPRJCATREL:*
END_SYMBOL_DEFINITIONS

<!-- ============================================================= -->
<!-- This SQL will return the elements of the Project              -->
<!-- noun(s) given project identifier(s)                           -->
<!-- The access profiles that apply to this SQL are:               -->
<!-- MyCompany_Summary project profiles                            -->
<!-- @param UniqueID - The project  identifier(s) .                -->
<!-- ============================================================= -->
BEGIN_XPATH_TO_SQL_STATEMENT
	name=/Project[ProjectIdentifier[(UniqueID=)]]+MyCompany_Admin_Summary	     
	base_table=XPROJECT
	sql=	
		SELECT 
	     				XPROJECT.$COLS:XPROJECT$,
	     				XPRJDES.$COLS:XPRJDES$

	     	FROM
	     				XPROJECT
	     				LEFT OUTER JOIN XPRJDES ON (XPROJECT.XPROJECT_ID = XPRJDES.XPROJECT_ID AND XPRJDES.LANGUAGE_ID IN ($CONTROL:LANGUAGES$) )
	     	WHERE
					XPROJECT.XPROJECT_ID IN (?UniqueID?) 


END_XPATH_TO_SQL_STATEMENT
BEGIN_XPATH_TO_SQL_STATEMENT
	name=/Project[ProjectIdentifier[(UniqueID=)]]+MyCompany_Store_Summary	     
	base_table=XPROJECT
	sql=	
		SELECT 
	     				XPROJECT.$COLS:XPROJECT$,
	     				XPRJDES.$COLS:XPRJDES$

	     	FROM
	     				XPROJECT
	     				LEFT OUTER JOIN XPRJDES ON (XPROJECT.XPROJECT_ID = XPRJDES.XPROJECT_ID AND XPRJDES.LANGUAGE_ID IN ($CONTROL:LANGUAGES$)  )
	     	WHERE
					XPROJECT.XPROJECT_ID IN (?UniqueID?) 


END_XPATH_TO_SQL_STATEMENT
<!-- ============================================================= -->
<!-- This SQL will return the elements of the Project              -->
<!-- noun(s) given project identifier(s)                           -->
<!-- The access profiles that apply to this SQL are:               -->
<!-- All project profiles                                          -->
<!-- @param UniqueID - The project  identifier(s) .                -->
<!-- ============================================================= -->
BEGIN_XPATH_TO_SQL_STATEMENT
	name=/Project[ProjectIdentifier[(UniqueID=)]]     
	base_table=XPROJECT
	sql=	
		SELECT 
	     				XPROJECT.$COLS:XPROJECT_ID$	     				

	     	FROM
	     				XPROJECT
	     				
	     	WHERE
					XPROJECT.XPROJECT_ID IN (?UniqueID?)


END_XPATH_TO_SQL_STATEMENT

<!-- ============================================================= -->
<!-- This SQL will return the elements of the Project              -->
<!-- noun(s) given catentry identifier(s)                           -->
<!-- The access profiles that apply to this SQL are:               -->
<!-- All project profiles                                          -->
<!-- @param UniqueID - The catentry  identifier(s) .                -->
<!-- ============================================================= -->
BEGIN_XPATH_TO_SQL_STATEMENT
	name=/Project[Tool[CatalogEntryIdentifier[(UniqueID=)]]]     
	base_table=XPROJECT
	sql=	
		SELECT 
	     			XPRJCATREL.XPROJECT_ID    				

	     	FROM
	     			XPRJCATREL
	     				
	     	WHERE
				XPRJCATREL.CATENTRY_ID IN (?UniqueID?) AND XPRJCATREL.STOREENT_ID IN ($STOREPATH:recipe$) 
 		

END_XPATH_TO_SQL_STATEMENT
<!-- ============================================================= -->
<!-- This SQL will return the elements of the Project              -->
<!-- noun(s) given catentry identifier(s)                           -->
<!-- The access profiles that apply to this SQL are:               -->
<!-- All project profiles                                          -->
<!-- @param UniqueID - The catentry  identifier(s) .                -->
<!-- ============================================================= -->
BEGIN_XPATH_TO_SQL_STATEMENT
	name=/Project[Material[CatalogEntry[CatalogEntryIdentifier[(UniqueID=)]]]] 
	base_table=XPROJECT
	sql=	
		
 		SELECT 
 				XPRJMTR.XPROJECT_ID
 		FROM 		
 				XPRJMTRCATREL,XPRJMTR
 		WHERE 		
 				XPRJMTRCATREL.XPRJMTR_ID=XPRJMTR.XPRJMTR_ID AND XPRJMTRCATREL.STOREENT_ID IN ($STOREPATH:recipe$) AND XPRJMTRCATREL.CATENTRY_ID IN (?UniqueID?)
 	

END_XPATH_TO_SQL_STATEMENT
<!-- ============================================================= -->
<!-- This SQL will return the elements of the Project              -->
<!-- noun(s) which have been assigned to the project collection    -->
<!-- identifier)                                                   -->
<!-- The access profiles that apply to this SQL are:               -->
<!-- All project profiles                                          -->
<!-- @param UniqueID - The project collection identifier(s) .      -->
<!-- @param Context:StoreID - The store for which to retrieve the  -->
<!--        project. This parameter is retrieved from within       -->
<!--	    the business context.           	                   -->
<!-- ============================================================= -->
BEGIN_XPATH_TO_SQL_STATEMENT
	name=/Project[Collection[ProjectCollectionIdentifier[(UniqueID=)]]]    	
	base_table=XPROJECT
	sql=	
		SELECT 
	     				XPROJECT.$COLS:XPROJECT_ID$	   	

	     	FROM
	     				XPRJPRJCOLREL,
					XPROJECT
	     				
	     	WHERE
					XPROJECT.XPROJECT_ID = XPRJPRJCOLREL.XPROJECT_ID AND XPRJPRJCOLREL.XPRJCOL_ID IN (?UniqueID?) 
					AND XPRJPRJCOLREL.STOREENT_ID IN ($STOREPATH:recipe$)



END_XPATH_TO_SQL_STATEMENT
<!-- ============================================================= -->
<!-- This SQL will return the elements of the Project              -->
<!-- noun(s) given the specified search criteria.                  -->
<!-- The access profiles that apply to this SQL are:               -->
<!-- All project profiles                                          -->
<!-- @param Context:StoreID - The store for which to retrieve the  -->
<!--        project. This parameter is retrieved from within       -->
<!--	    the business context.           	                   -->
<!-- ============================================================= -->
BEGIN_XPATH_TO_SQL_STATEMENT
	name=/Project[search()]
	paging_result_limit=500
	base_table=XPROJECT
	sql=
		SELECT 
			XPROJECT.$COLS:XPROJECT_ID$	   
		FROM
			XPROJECT, $ATTR_TBLS$
		WHERE 
			XPROJECT.STOREENT_ID IN ($STOREPATH:recipe$) AND	
			( $ATTR_CNDS$ ) 
END_XPATH_TO_SQL_STATEMENT


<!-- ============================================================ -->
<!-- This associated SQL:                                         -->
<!-- Adds project material Info                                    -->
<!-- to the resultant data graph.                                 -->
<!-- ============================================================ -->
BEGIN_ASSOCIATION_SQL_STATEMENT
	name=MyCompany_ProjectMaterial	     
	base_table=XPROJECT
	sql=	
		SELECT 
	     				XPROJECT.$COLS:XPROJECT_ID$,
	     				XPRJMTR.$COLS:XPRJMTR$,
					XPRJMTRDES.$COLS:XPRJMTRDES$,
					XPRJMTRCATREL.$COLS:XPRJMTRCATREL$
	     	FROM
	     				XPROJECT, 
					XPRJMTR
	     				LEFT OUTER JOIN XPRJMTRDES ON (XPRJMTR.XPRJMTR_ID = XPRJMTRDES.XPRJMTR_ID AND XPRJMTRDES.LANGUAGE_ID IN ($CONTROL:LANGUAGES$) )
					LEFT OUTER JOIN XPRJMTRCATREL ON (XPRJMTR.XPRJMTR_ID = XPRJMTRCATREL.XPRJMTR_ID AND XPRJMTRCATREL.STOREENT_ID IN ($STOREPATH:recipe$))

	     	WHERE
					XPROJECT.XPROJECT_ID IN ($ENTITY_PKS$) AND XPROJECT.XPROJECT_ID = XPRJMTR.XPROJECT_ID 


END_ASSOCIATION_SQL_STATEMENT
<!-- ============================================================ -->
<!-- This associated SQL:                                         -->
<!-- Adds project instruction Info                                -->
<!-- to the resultant data graph.                                 -->
<!-- ============================================================ -->
BEGIN_ASSOCIATION_SQL_STATEMENT
	name=MyCompany_ProjectInstruction	     
	base_table=XPROJECT
	sql=	
		SELECT 
	     				XPROJECT.$COLS:XPROJECT_ID$,
	     				XPRJINS.$COLS:XPRJINS$,
					XPRJINSDES.$COLS:XPRJINSDES$
					
	     	FROM
	     				XPROJECT, 
					XPRJINS
	     				LEFT OUTER JOIN XPRJINSDES ON (XPRJINS.XPRJINS_ID = XPRJINSDES.XPRJINS_ID AND XPRJINSDES.LANGUAGE_ID IN ($CONTROL:LANGUAGES$))					

	     	WHERE
					XPROJECT.XPROJECT_ID IN ($ENTITY_PKS$) AND XPROJECT.XPROJECT_ID = XPRJINS.XPROJECT_ID 
		
		ORDER BY 
					XPRJINS.XPROJECT_ID,XPRJINS.SEQ

END_ASSOCIATION_SQL_STATEMENT
<!-- ============================================================ -->
<!-- This associated SQL:                                         -->
<!-- Adds project and project collection relationship Info        -->
<!-- to the resultant data graph.                                 -->
<!-- ============================================================ -->
BEGIN_ASSOCIATION_SQL_STATEMENT

	name=MyCompany_ProjectColRel	     
	base_table=XPROJECT
	sql=	
		SELECT 
	     			XPROJECT.$COLS:XPROJECT_ID$,
					XPRJPRJCOLREL.$COLS:XPRJPRJCOLREL$,
	     			XPRJCOL.$COLS:XPRJCOL$,
					XPRJCOLDES.$COLS:XPRJCOLDES$
					
	     	FROM
	     				XPROJECT,
					XPRJPRJCOLREL, 
					XPRJCOL
	     				LEFT OUTER JOIN XPRJCOLDES ON (XPRJCOL.XPRJCOL_ID = XPRJCOLDES.XPRJCOL_ID AND XPRJCOLDES.LANGUAGE_ID IN ($CONTROL:LANGUAGES$))					

	     	WHERE
					XPROJECT.XPROJECT_ID IN ($ENTITY_PKS$) AND XPRJPRJCOLREL.XPROJECT_ID = XPROJECT.XPROJECT_ID 
					AND XPRJPRJCOLREL.XPRJCOL_ID = XPRJCOL.XPRJCOL_ID  AND XPRJPRJCOLREL.STOREENT_ID IN ($STOREPATH:recipe$) 


END_ASSOCIATION_SQL_STATEMENT

<!-- ============================================================ -->
<!-- This associated SQL:                                         -->
<!-- Adds project tools Info                                      -->
<!-- to the resultant data graph.                                 -->
<!-- ============================================================ -->
BEGIN_ASSOCIATION_SQL_STATEMENT

	name=MyCompany_ProjectTool	     
	base_table=XPROJECT
	sql=	
		SELECT 
	     				XPROJECT.$COLS:XPROJECT_ID$,
	     				XPRJCATREL.$COLS:XPRJCATREL$

	     	FROM
	     				XPROJECT
	     				LEFT OUTER JOIN XPRJCATREL ON (XPROJECT.XPROJECT_ID = XPRJCATREL.XPROJECT_ID AND XPRJCATREL.STOREENT_ID IN ($STOREPATH:recipe$) )
	     	WHERE
					XPROJECT.XPROJECT_ID IN ($ENTITY_PKS$) 


END_ASSOCIATION_SQL_STATEMENT
<!-- ============================================================ -->
<!-- This associated SQL:                                         -->
<!-- Adds Project with description Info                           -->
<!-- to the resultant data graph.                                 -->
<!-- ============================================================ -->
BEGIN_ASSOCIATION_SQL_STATEMENT
	name=MyCompany_ProjectDescription	     
	base_table=XPROJECT
	sql=	
		SELECT 
	     				XPROJECT.$COLS:XPROJECT$,
	     				XPRJDES.$COLS:XPRJDES$

	     	FROM
	     				XPROJECT
	     				LEFT OUTER JOIN XPRJDES ON (XPROJECT.XPROJECT_ID = XPRJDES.XPROJECT_ID AND XPRJDES.LANGUAGE_ID IN ($CONTROL:LANGUAGES$) )
	     	WHERE
					XPROJECT.XPROJECT_ID IN ($ENTITY_PKS$) 

END_ASSOCIATION_SQL_STATEMENT

<!-- ============================================================= -->
<!-- This SQL will return the elements of the Project              -->
<!-- noun(s) which have been assigned to the project collection    -->
<!-- identifier)                                                   -->
<!-- The access profiles that apply to this SQL are:               -->
<!-- MyCompany_Summary profiles                                    -->
<!-- @param UniqueID - The project collection identifier(s) .      -->
<!-- @param Context:StoreID - The store for which to retrieve the  -->
<!--        project. This parameter is retrieved from within       -->
<!--	    the business context.           	                   -->
<!-- ============================================================= -->
BEGIN_XPATH_TO_SQL_STATEMENT
	name=/Project[Collection[ProjectCollectionIdentifier[(UniqueID=)]]]+MyCompany_Store_Summary	     
	base_table=XPROJECT
	sql=	
		SELECT 
	     				XPROJECT.$COLS:XPROJECT$,
	     				XPRJDES.$COLS:XPRJDES$

	     	FROM
	     				XPRJPRJCOLREL,
					XPROJECT
	     				LEFT OUTER JOIN XPRJDES ON (XPROJECT.XPROJECT_ID = XPRJDES.XPROJECT_ID AND XPRJDES.LANGUAGE_ID IN ($CONTROL:LANGUAGES$))
	     	WHERE
					XPROJECT.XPROJECT_ID = XPRJPRJCOLREL.XPROJECT_ID AND XPRJPRJCOLREL.XPRJCOL_ID in (?UniqueID?)
                    AND XPRJPRJCOLREL.STOREENT_ID IN ($STOREPATH:recipe$) 

END_XPATH_TO_SQL_STATEMENT
<!-- ============================================================= -->
<!-- This SQL will return the elements of the Project              -->
<!-- noun(s) which are not been assigned to a project collection   -->
<!-- identifier)                                                   -->
<!-- The access profiles that apply to this SQL are:               -->
<!-- All project profiles                                          -->
<!-- @param Context:StoreID - The store for which to retrieve the  -->
<!--        project. This parameter is retrieved from within       -->
<!--	    the business context.           	                   -->
<!-- ============================================================= -->
BEGIN_XPATH_TO_SQL_STATEMENT
	name=/Project[Unassigned] 
	base_table=XPROJECT
	sql= 
		SELECT 
			XPROJECT.$COLS:XPROJECT_ID$ 
		FROM 
			XPROJECT
		
		WHERE
			XPROJECT.STOREENT_ID IN ($STOREPATH:recipe$) AND
			XPROJECT.XPROJECT_ID NOT IN (SELECT DISTINCT XPROJECT_ID FROM XPRJPRJCOLREL WHERE STOREENT_ID IN ($STOREPATH:recipe$) ) 

END_XPATH_TO_SQL_STATEMENT
<!-- =========================================================  -->
<!-- Project Details Access Profile.                            -->
<!-- This profile returns the following info:                   -->
<!-- 	Project with description.                               -->
<!-- 	Project  Materials.                                     -->
<!-- 	Project  instructions.                                  -->
<!-- 	Project and project collection relationship.            -->
<!-- 	Project tools.                                          -->
<!-- =========================================================  -->
BEGIN_PROFILE 
	name=MyCompany_Admin_Details
	BEGIN_ENTITY 
	  base_table=XPROJECT
	  className=com.ibm.commerce.foundation.internal.server.services.dataaccess.graphbuilderservice.DefaultGraphComposer
        associated_sql_statement=MyCompany_ProjectDescription
        associated_sql_statement=MyCompany_ProjectMaterial
        associated_sql_statement=MyCompany_ProjectInstruction
        associated_sql_statement=MyCompany_ProjectColRel
        associated_sql_statement=MyCompany_ProjectTool

    END_ENTITY
END_PROFILE
BEGIN_PROFILE 
	name=MyCompany_Store_Details
	BEGIN_ENTITY 
	  base_table=XPROJECT
	  className=com.ibm.commerce.foundation.internal.server.services.dataaccess.graphbuilderservice.DefaultGraphComposer
        associated_sql_statement=MyCompany_ProjectDescription
        associated_sql_statement=MyCompany_ProjectMaterial
        associated_sql_statement=MyCompany_ProjectInstruction
        associated_sql_statement=MyCompany_ProjectColRel
        associated_sql_statement=MyCompany_ProjectTool

    END_ENTITY
END_PROFILE
<!-- =========================================================  -->
<!-- Project Materials Access Profile.                          -->
<!-- This profile returns the following info:                   -->
<!-- 	Project Materials.                                      -->
<!-- =========================================================  -->
BEGIN_PROFILE 
	name=MyCompany_Admin_ProjectMaterial
	BEGIN_ENTITY 
	  base_table=XPROJECT
	  className=com.ibm.commerce.foundation.internal.server.services.dataaccess.graphbuilderservice.DefaultGraphComposer
      
	associated_sql_statement=MyCompany_ProjectMaterial

    END_ENTITY
END_PROFILE
<!-- =========================================================  -->
<!-- Project Instructions Access Profile.                       -->
<!-- This profile returns the following info:                   -->
<!-- 	Project  instructions.                                  -->
<!-- =========================================================  -->
BEGIN_PROFILE 
	name=MyCompany_Admin_ProjectInstruction
	BEGIN_ENTITY 
	  base_table=XPROJECT
	  className=com.ibm.commerce.foundation.internal.server.services.dataaccess.graphbuilderservice.DefaultGraphComposer
      
	associated_sql_statement=MyCompany_ProjectInstruction

    END_ENTITY
END_PROFILE
<!-- =========================================================  -->
<!-- Project and project collection relationship Access Profile.-->
<!-- This profile returns the following info:                   -->
<!-- 	Project and project collection relationship.            -->
<!-- =========================================================  -->
BEGIN_PROFILE 
	name=MyCompany_Admin_ProjectColRel
	BEGIN_ENTITY 
	  base_table=XPROJECT
	  className=com.ibm.commerce.foundation.internal.server.services.dataaccess.graphbuilderservice.DefaultGraphComposer
      
	associated_sql_statement=MyCompany_ProjectColRel

    END_ENTITY
END_PROFILE
<!-- ========================================================= -->
<!-- Project Tools Access Profile.                             -->
<!-- This profile returns the following info:                  -->
<!-- 	Project tools.                                         -->
<!-- ========================================================= -->
BEGIN_PROFILE 
	name=MyCompany_Admin_ProjectTool
	BEGIN_ENTITY 
	  base_table=XPROJECT
	  className=com.ibm.commerce.foundation.internal.server.services.dataaccess.graphbuilderservice.DefaultGraphComposer
      
	associated_sql_statement=MyCompany_ProjectTool

    END_ENTITY
END_PROFILE
<!-- ========================================================= -->
<!-- Project Summary Access Profile.                           -->
<!-- This profile returns the following info:                  -->
<!-- 	Project with description.                              -->
<!-- ========================================================= -->
BEGIN_PROFILE 
	name=MyCompany_Admin_Summary
	BEGIN_ENTITY 
	  base_table=XPROJECT
	  className=com.ibm.commerce.foundation.internal.server.services.dataaccess.graphbuilderservice.DefaultGraphComposer
      
	associated_sql_statement=MyCompany_ProjectDescription
	associated_sql_statement=MyCompany_ProjectColRel

    END_ENTITY
END_PROFILE
BEGIN_PROFILE 
	name=MyCompany_Store_Summary
	BEGIN_ENTITY 
	  base_table=XPROJECT
	  className=com.ibm.commerce.foundation.internal.server.services.dataaccess.graphbuilderservice.DefaultGraphComposer
      
	associated_sql_statement=MyCompany_ProjectDescription

    END_ENTITY
END_PROFILE





